--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNalignmentParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCalign
  local LOCgeomInfoPopulated = false

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNchangeTab FUNtab FUNalign =
  (
    local LOCoffset1, LOCoffset2
    LOCoffset1 = LOCoffset2 = 0
    if FUNtab == 1 then (LOCoffset1 = 0; LOCoffset2 = -2000; DYNalignmentParams.LBtabDescription.text = DYNuiResourcesLabels[123])
    if FUNtab == 2 then (LOCoffset2 = 0; LOCoffset1 = -2000; DYNalignmentParams.LBtabDescription.text = DYNuiResourcesLabels[125])

    -- Layout Controls for Tab 1
    DYNalignmentParams.GBDYN03.pos.x             = LOCoffset1 + 13
    DYNalignmentParams.LBDYNmodel01.pos.x        = LOCoffset1 + 22
    DYNalignmentParams.LBDYNmodel02.pos.x        = LOCoffset1 + 27
    DYNalignmentParams.LBDYNstring01.pos.x       = LOCoffset1 + 22
    DYNalignmentParams.LBDYNstring02.pos.x       = LOCoffset1 + 27
    DYNalignmentParams.GBDYN04.pos.x             = LOCoffset1 + 13
    DYNalignmentParams.LBDYNimported.pos.x       = LOCoffset1 + 27
    DYNalignmentParams.GBDYN05.pos.x             = LOCoffset1 + 13
    DYNalignmentParams.LBDYNsource.pos.x         = LOCoffset1 + 22
    DYNalignmentParams.LBDYNmodify01.pos.x       = LOCoffset1 + 22
    DYNalignmentParams.LBDYNmodify02.pos.x       = LOCoffset1 + 27
    DYNalignmentParams.BUDYNupdate.pos.x         = LOCoffset1 + 13

    -- Layout Controls for Tab 2
    DYNalignmentParams.GBDYN01.pos.x             = LOCoffset2 + 13
    DYNalignmentParams.LBDYNstartStation.pos.x   = LOCoffset2 + 22
    DYNalignmentParams.LBDYNendStation.pos.x     = LOCoffset2 + 22
    DYNalignmentParams.LBDYNactualLength.pos.x   = LOCoffset2 + 22
    DYNalignmentParams.dnTreeView.pos.x          = LOCoffset2 + 22
    DYNalignmentParams.LBDYNcurrentProfile.pos.x = LOCoffset2 + 22
    DYNalignmentParams.DDDYNcurrentProfile.pos.x = LOCoffset2 + 22
    DYNalignmentParams.BUDYNreport.pos.x         = LOCoffset2 + 22
    DYNalignmentParams.GBDYN02.pos.x             = LOCoffset2 + 13
    DYNalignmentParams.dnListView.pos.x          = LOCoffset2 + 22
    /*
    DYNalignmentParams.BUDYNaddDesignSpeed.pos.x = LOCoffset2 + 22
    DYNalignmentParams.BUDYNremDesignSpeed.pos.x = LOCoffset2 + (22 + (((DYNiniExplorerWidth - 58) / 2) + 4))
    */

    -- Populate Controls for Tab 2
    if FUNtab == 2 then
    (
      if FUNalign != undefined and not DYNalignmentParams.LOCgeomInfoPopulated then
      (
        --- Continue Loading Shape Object
        local LOCnumKnots    = numKnots FUNalign
        if LOCnumKnots > 1 then
        (
          --- Set Units
          local LOClengthUnit = " "
          if units.systemType == #inches      then LOClengthUnit += DYNuiResourcesUnitsDistance[8]
          if units.systemType == #feet        then LOClengthUnit += DYNuiResourcesUnitsDistance[7]
          if units.systemType == #miles       then LOClengthUnit += DYNuiResourcesUnitsDistance[6]
          if units.systemType == #millimeters then LOClengthUnit += DYNuiResourcesUnitsDistance[5]
          if units.systemType == #centimeters then LOClengthUnit += DYNuiResourcesUnitsDistance[4]
          if units.systemType == #meters      then LOClengthUnit += DYNuiResourcesUnitsDistance[2]
          if units.systemType == #kilometers  then LOClengthUnit += DYNuiResourcesUnitsDistance[3]

          --- Alignment Params
          DYNalignmentParams.LBDYNstartStation.text      = DYNuiResourcesLabels[9]   + "  " + (FUNalign.startStation as string)
          DYNalignmentParams.LBDYNendStation.text        = DYNuiResourcesLabels[10]  + "  " + (FUNalign.endStation as string)
          DYNalignmentParams.LBDYNactualLength.text      = DYNuiResourcesLabels[205] + "  " + ((curveLength FUNalign 1) as string) + LOClengthUnit
          DYNalignmentParams.DDDYNcurrentProfile.enabled = false -- if FUNalign.DatasetNameArray.count >= 2 then true else false
          DYNalignmentParams.LBDYNcurrentProfile.enabled = false -- if FUNalign.DatasetNameArray.count >= 2 then true else false

          --- Display Vertex Datasets in TreeView and Profiles in DropDownList
          local LOCprofileNameArray = #(); LOCprofileNameArray.count = FUNalign.DatasetNameArray.count
          local LOCrootNode         = DYNalignmentParams.dnTreeView.nodes.add ("1") FUNalign.DatasetNameArray[1] 16 16
          LOCrootNode.checked = true
          LOCprofileNameArray[1] = DYNuiResourcesLabels[204]
          if FUNalign.DatasetNameArray.count >= 2 then
          (
            for i = 2 to FUNalign.DatasetNameArray.count do
            (
              LOCprofileNameArray[i] = FUNalign.DatasetNameArray[i]
              local LOCprofileNode = LOCrootNode.nodes.add (i as string) FUNalign.DatasetNameArray[i] 60 60
              if i == FUNalign.CurrentDataset then LOCprofileNode.checked = true
            )
          )
          DYNalignmentParams.DDDYNcurrentProfile.items = LOCprofileNameArray
          DYNalignmentParams.DDDYNcurrentProfile.selection = FUNalign.CurrentDataset
          LOCrootNode.expand()

          --- Display Design Speeds in ListView
          local LOClistItemRange = #()
          for i = 1 to FUNalign.designSpeedStations.count do
          (
            local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (FUNalign.designSpeedStations[i] as string)
            LOClistItem.imageIndex  = 1
            LOClistItem.toolTipText = FUNalign.designSpeedComments[i]
            LOClistItem.SubItems.add (FUNalign.designSpeedValues[i] as string)

            append LOClistItemRange LOClistItem
          )
          DYNalignmentParams.dnListView.Items.AddRange LOClistItemRange
          DYNalignmentParams.LOCgeomInfoPopulated = true
        )
      )
    )
  )


  fn DYNFUNalignParams FUNalign =
  (
    if FUNalign != undefined then
    (
      --- Display Source Information
      local LOCappData424 = (getAppData FUNalign 424) as string
      if (getAppData FUNalign 422) == "16" then
      (
        DYNalignmentParams.LBDYNmodel02.text   = DYNFUNdisplayAppDataInUI ((getAppData FUNalign 428) as string)
        DYNalignmentParams.LBDYNstring02.text  = DYNFUNdisplayAppDataInUI ((getAppData FUNalign 427) as string)
        DYNalignmentParams.LBDYNimported.text  = DYNFUNconvertGUPdate     ((getAppData FUNalign 425) as string)
        DYNalignmentParams.LBDYNsource.text    = filenameFromPath LOCappData424

        if doesFileExist LOCappData424 then
        (
          if (stricmp (getFilenameType LOCappData424) ".fil") == 0 then
          (
            --- For Model Files
            local LOCmodelName      = (getAppData FUNalign 428) as string; while LOCmodelName.count < 28 do LOCmodelName += " "
            local LOCmxModelmodDate = DYNFUNgetMxModelFileModelModifyTime LOCappData424 LOCmodelName
            DYNalignmentParams.LBDYNmodify02.text  = if classOf LOCmxModelmodDate == string then DYNFUNconvertGUPdate LOCmxModelmodDate
          )
          else
          (
            --- For other file types
            DYNalignmentParams.LBDYNmodify02.text  = DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime LOCappData424 true)
          )
          if (findString DYNalignmentParams.LBDYNmodify02.text DYNuiResourcesLabels[120]) != undefined then DYNalignmentParams.LBDYNmodify02.text = "-"
        )
        else
        (
          DYNalignmentParams.LBDYNmodify02.text  = ""
        )

        DYNalignmentParams.BUDYNupdate.enabled = if DYNalignmentParams.LBDYNmodel02.text != "" and DYNalignmentParams.LBDYNstring02.text != "" then true else false

        --- Surface breaklines from LandXML cannot be updated
        if (stricmp (getFilenameType LOCappData424) ".xml") == 0 then DYNalignmentParams.BUDYNupdate.enabled = false
      )
      else
      (
        DYNalignmentParams.LBDYNmodel02.text   = DYNuiResourcesLabels[121]
        DYNalignmentParams.LBDYNstring02.text  = DYNuiResourcesLabels[121]
        DYNalignmentParams.LBDYNimported.text  = DYNuiResourcesLabels[121]
        DYNalignmentParams.LBDYNsource.text    = DYNuiResourcesLabels[121]
        DYNalignmentParams.LBDYNmodify02.text  = DYNuiResourcesLabels[121]
        DYNalignmentParams.BUDYNupdate.enabled = false
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNtab pos:[4,28] width:(DYNiniExplorerWidth - 21) height:382
  dotNetControl dnRolloutTabCtrl "System.Windows.Forms.TabControl" height:23  width:(DYNiniExplorerWidth - 23) pos:[5,12]
  label LBDYNspacer pos:[10,20]
  label LBtabDescription align:#center

  -- Tab 1 Controls
  groupbox GBDYN03 width:(DYNiniExplorerWidth - 39) height:132 pos:[2013,57]
  label LBDYNmodel01  align:#left pos:[2022,76]
  label LBDYNmodel02  align:#left pos:[2027,94] width:(DYNiniExplorerWidth - 58) height:38
  label LBDYNstring01 align:#left pos:[2022,130]
  label LBDYNstring02 align:#left pos:[2027,148] width:(DYNiniExplorerWidth - 58) height:38

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 39) height:38 pos:[2013,193]
  label LBDYNimported align:#left pos:[2018,211] width:(DYNiniExplorerWidth - 58)

  groupbox GBDYN05 width:(DYNiniExplorerWidth - 39) height:74 pos:[2013,236]
  label LBDYNsource align:#left pos:[2022,254] width:(DYNiniExplorerWidth - 58)
  label LBDYNmodify01 align:#left pos:[2022,272] width:(DYNiniExplorerWidth - 58)
  label LBDYNmodify02 align:#left pos:[2027,290] width:(DYNiniExplorerWidth - 58)

  button BUDYNupdate width:(DYNiniExplorerWidth - 39)    pos:[2013,319]

  -- Tab 2 Controls
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 39) height:219 pos:[2013,57]
  label LBDYNstartStation align:#left pos:[2022,76]  width:(DYNiniExplorerWidth - 58)
  label LBDYNendStation align:#left pos:[2022,94]    width:(DYNiniExplorerWidth - 58)
  label LBDYNactualLength align:#left pos:[2022,112] width:(DYNiniExplorerWidth - 58)
  dotNetControl dnTreeView "System.Windows.Forms.TreeView" pos:[2022,134] width:(DYNiniExplorerWidth - 58) height:65
  label LBDYNcurrentProfile align:#left pos:[2022,204] width:(DYNiniExplorerWidth - 58)
  dropdownlist DDDYNcurrentProfile  width:(DYNiniExplorerWidth - 58) pos:[2022,219]
  button BUDYNreport width:(DYNiniExplorerWidth - 58) pos:[2022,245]

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 39) height:120 pos:[2013,281]
  dotNetControl dnListView "System.Windows.Forms.ListView"   pos:[2022,300] width:(DYNiniExplorerWidth - 58) height:90
  /*
  button BUDYNaddDesignSpeed width:(((DYNiniExplorerWidth - 58) / 2) - 2) pos:[2022,396] enabled:false
  button BUDYNremDesignSpeed width:(((DYNiniExplorerWidth - 58) / 2) - 2) pos:[(2022 + (((DYNiniExplorerWidth - 58) / 2) + 4)),396] enabled:false
  */

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNalignmentParams open do
  (
    LOCgeomInfoPopulated          = false
    LOCalign = $

    DYNFUNdnTreeViewStyle dnTreeView
    --dnTreeView.enabled            = false

    DYNFUNdnListViewStyle dnListView false false
    dnListView.sorting            = DYNdnSortOrderClass.ascending
    dnListView.smallImageList     = DYNdnSmImageList
    dnListView.ShowItemToolTips   = true
    local LOCcol2                 = dnListView.Columns.add (DYNuiResourcesLvColumns[50]) 60
    LOCcol2.textAlign             = DYNdnHorAlignClass.center
    local LOCcol3                 = dnListView.Columns.add (DYNuiResourcesLvColumns[8] + " (" + DYNuiResourcesUnitsDistance[DYNINIspeedValue.x] + "/" + DYNuiResourcesUnitsTime[DYNINIspeedValue.y] + ")") 95
    LOCcol3.textAlign             = DYNdnHorAlignClass.center

    DYNalignmentParams.title      = DYNuiRolloutNames[18]
    GBDYN01.text                  = DYNuiResourcesGroups[63]
    GBDYN02.text                  = DYNuiResourcesGroups[64]
    GBDYN03.text                  = DYNuiResourcesGroups[33]
    GBDYN04.text                  = DYNuiResourcesGroups[34]
    GBDYN05.text                  = DYNuiResourcesGroups[7]
    BUDYNreport.text              = DYNuiResourcesButtons[56]
    BUDYNupdate.text              = DYNuiResourcesButtons[14]
    LBDYNmodel01.text             = DYNuiResourcesLabels[51]
    LBDYNstring01.text            = DYNuiResourcesLabels[50]
    LBDYNmodify01.text            = DYNuiResourcesLabels[33]
    LBDYNcurrentProfile.text      = DYNuiResourcesLabels[206]
    dnTreeView.checkboxes         = false
    dnTreeView.imageList          = DYNdnSmImageList

    /*
    BUDYNaddDesignSpeed.text      = DYNuiResourcesButtons[11]
    BUDYNremDesignSpeed.text      = DYNuiResourcesButtons[12]
    */

    dnRolloutTabCtrl.padding.x    = 10
    dnRolloutTabCtrl.tabpages.add DYNuiResourcesLabels[117]
    dnRolloutTabCtrl.tabpages.add DYNuiResourcesLabels[119]

    DYNFUNchangeTab 1 LOCalign
  )

  on DYNalignmentParams close do
  (
    LOCalign = undefined
    LOCgeomInfoPopulated = false
    dnTreeView.nodes.clear()
    dnListView.items.clear()
  )

  on dnRolloutTabCtrl mouseUp arg do
  (
    DYNFUNchangeTab (dnRolloutTabCtrl.selectedTab.TabIndex + 1) LOCalign
  )

  on BUDYNreport pressed do
  (
    DYNFUNmakeAlignmentReport LOCalign false true
  )

  on BUDYNupdate pressed do
  (
    APCFUNupdateImportedObjects #(LOCalign) true DYNtempPath
    APCFUNupdateAllPlacedObjectControllers()
  )
)
